/******************************************************************************
 * GUI.h - Gestion de l'interface graphique                                   *
 ******************************************************************************
 * Projet       : Archive(R)                                                  *
 * Auteur       : Arnaud Storq (http://norecess.planet-d.net)                 *
 ******************************************************************************/
#ifndef __GUI_H__
#define __GUI_H__

// ---------------------------------------------------------------------------- INCLUDE ADDITIONNELS
#include "Archive.h"

// ---------------------------------------------------------------------------- GUI
class GUI : public wxFrame
{
public:
    GUI();
      
private:
    void initialiserFenetre();
    void initialiserMenu();
    void initialiserListe();
      
private:
    void archiveOuvrir(wxCommandEvent &event);
    void archiveSauvegarder(wxCommandEvent &event);
    void fichierAjouter(wxCommandEvent &event);
    void fichierSupprimer(wxCommandEvent &event);
    void fichierExtraire(wxCommandEvent &event);
    void fichierExtraireTout(wxCommandEvent &event);
    void archiveurAPropos(wxCommandEvent &event);
    void archiveurQuitter(wxCommandEvent &event);
                  
private:
    // Cette methode permet de convertir un entier en chaine de caracteres
    // destine  etre affiche dans l'outil. Exemples :
    // 954 retournera "954 octets"
    // 10248 retournera "10 Ko"
    string convertirEntierEnTaille(int taille);
    
    // Cette mthode permet la creation d'un rpertoire.
    // Elle est notemment utilise lorsque l'on veut extraire
    // un fichier mais que son rpertoire de destination
    // n'existe pas.
    void creerRepertoire(string &nomFichier);
    
private:
    // Le controle de liste de wxWindows.
    // Il va contenir 3 colonnes (nom du fichier, taille compresse et taille originale).
    // De nombreuses mthodes sont disponibles pour sa gestion..
    wxListCtrl *m_liste;
    
    // Ce membre va nous servir pour manipuler l'archive.
    // Le modele document/vue est donc respect ;
    // nous pourrions trs bien imaginer changer de librairies d'interface
    // (pour migrer vers Qt, MFC, ..) en changeant juste notre classe GUI,
    // sans en modifier la gestion de l'archive.
    Archive m_archive;
    
private:
    // Permet  wxWindows de gerer sa table d'evenements.
    DECLARE_EVENT_TABLE()
};

// ---------------------------------------------------------------------------- FIN
#endif // __GUI_H__

